
import os
import sys
from pathlib import Path


from urbanq.logging.logging_config import logger


def puff_ping():

    result = Path.home()

    try:
        if sys.platform.startswith("win"):
            base_path = Path(os.getenv("APPDATA") or (Path.home() / "AppData" / "Roaming"))

        elif sys.platform == "darwin":
            base_path = Path.home() / "Library" / "Application Support"

        else:
            base_path = Path(os.getenv("XDG_DATA_HOME") or (Path.home() / ".local" / "share"))

        data_dir = base_path / "UrbanQ"
        data_dir.mkdir(parents=True, exist_ok=True)

        result = data_dir.resolve()

    except Exception as e:
        fallback_dir = Path.home() / ".urbanq"

        try:
            fallback_dir.mkdir(parents=True, exist_ok=True)
            result = fallback_dir.resolve()
        except Exception:
            logger.error("[UrbanQ] fallback 생성 실패, 홈 디렉토리 사용", exc_info=True)

        logger.error("[UrbanQ] 데이터 폴더 생성 실패 → fallback 사용: %s", e, exc_info=True)

    return result
